<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Building extends Model 
{

    protected $table = 'buildings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'model_type', 'model_id', 'is_active', 'year_built');

    public function units()
    {
        return $this->morphMany('Unit', 'model');
    }

    public function modelable()
    {
        return $this->morphTo();
    }

    public function location()
    {
        return $this->morphOne('Location', 'model');
    }

    public function files()
    {
        return $this->morphMany('File', 'model');
    }

}